#ifndef PONG_HIGH_SCORE_H
#define PONG_HIGH_SCORE_H

//la fonction qui lit les scores!
//retours:
//Elle a trouv des scores et les a charg en RAM
//Elle a pas trouv de scores et cree une table de score vierge en RAM
HIGH_SCORE_ENTRY* load_scores(char* path, int* nb_high_score_entries);

//on vrifie si les scores du joueur sont dans la table
//RETOURS
//LA POSITION DANS LE HISCORE
//-1 : Trop mauvais, ils n'y sont pas!
int check_scores(HIGH_SCORE_ENTRY* score_table, int size_score_table, int score);

//LA focntion cre une table de records vides (en RAM seulement)!
//elle retoune un pointeur dessus
HIGH_SCORE_ENTRY* create_empty_score_table(int size_score_table);

   
//rcupre une chaine d'un fichier
int get_pack_string(char* str, PACKFILE* f);

//Fonction qui rajoute le nom et le score dans la table!
//elle "pousse" les scores infrieurs
//score_table, le tableau ou l'on insre la valeur.
//score_table_size : sa taille
//name : le nom  entrer
//score : son score
void update_scores(HIGH_SCORE_ENTRY *score_table, int score_table_size, char *name, int score);

//fonction qui change le nom d'un score
//score_table, le tableau ou on change le nom
//name : le nom  entrer
//pos : la position dans le tableau
void change_score_name(HIGH_SCORE_ENTRY *score_table, char *name, int pos);


//COPIE LE CONTENU INTEGRAL DES SCORES DE LA RAM VERS LE FICHIER
//Retour: void
void save_scores(HIGH_SCORE_ENTRY* hi_score, char* path, int score_table_size);

#endif